/* ==================================================================== */
/* QRMn_rand - Generates Random Numbers Using Factored Multiplication	*/
/* ==================================================================== */
#include <stdlib.h>
#define	MOD	2147483647L
# if defined(QRM_1)
#	define	MULT	41358L
#	define	Q	51924L
#	define	R	10855L
#	define	NAME	Qrm1_rand
# elif defined(QRM_2)
#	define	MULT	48271L
#	define	Q	44488L
#	define	R	 3399L
#	define	NAME	Qrm2_rand
# elif defined(QRM_3)
#	define	MULT	69621L
#	define	Q	30845L
#	define	R	23902L
#	define	NAME	Qrm3_rand
# else
#	define	MULT	16807L
#	define	Q	127773L
#	define	R	2836L
#	define	NAME	Qrm4_rand
# endif
extern	unsigned long _Randseed;
int
NAME(void)
{
    long    Residue;
    Residue = MULT * (_Randseed % Q) - R * (_Randseed / Q);
    _Randseed = (Residue > 0) ? Residue : Residue + MOD;

    return ((unsigned int) (_Randseed >> 8 & RAND_MAX));
}
